﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="System.Collections.Generic" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Zestawienie obrotów i sald</title>
	<script runat="server">

		private ObrotyKontaWorker okw = null;
		private Hashtable konta = new Hashtable();

		private void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args)
		{
			okw.Konto = (KontoBase)args.Row;
			KontoBase kn = okw.Konto.Nadrzedne;
			bool sum = true;

			while (kn != null)
			{
				if (konta[kn] != null)
				{
					sum = false;
					break;
				}
				kn = okw.Konto.Table.WgOkres[okw.Konto.Okres, kn.SymbolNadrzednego.TrimEnd(KontoBase.Separator)];
			}

			Boolean bold = p.WyrozniajSyntetyki && okw.Konto.Poziom <= 1;

			colNazwa.EditValue = mapToBold(HttpUtility.HtmlEncode(okw.Konto.Nazwa), bold);
			colSymbol.EditValue = mapToBold(HttpUtility.HtmlEncode(okw.Konto.Symbol), bold); 

			colBOWn.EditValue = okw.SaldoBOWn;
			colBOMa.EditValue = okw.SaldoBOMa;
			colSaldoBO.EditValue = okw.SaldoBO;
			colObrotyWn.EditValue = okw.ObrotyWn;
			colObrotyMa.EditValue = okw.ObrotyMa;
			colObrotyNWn.EditValue = okw.ObrotyNWn;
			colObrotyNMa.EditValue = okw.ObrotyNMa;
			colSaldoWn.EditValue = okw.SaldoWn;
			colSaldoMa.EditValue = okw.SaldoMa;
			colPerSaldo.EditValue = okw.PerSaldo;

			colBOWn.SumRow = colBOMa.SumRow = colSaldoBO.SumRow = colObrotyWn.SumRow = colObrotyMa.SumRow = colObrotyNWn.SumRow = colObrotyNMa.SumRow = colSaldoWn.SumRow = colSaldoMa.SumRow = colPerSaldo.SumRow = sum;
			colBOWn.Format = colBOMa.Format = colSaldoBO.Format = colObrotyWn.Format = colObrotyMa.Format = colObrotyNWn.Format = colObrotyNMa.Format = colSaldoWn.Format = colSaldoMa.Format = colPerSaldo.Format = mapToBold("{0:n}", bold);
		}

		
		private String mapToBold(String str, Boolean map)
		{ return map ? "<b>" + str + "</b>" : str; }
		
		
		private void ZestawienieObrotówISald_OnLoad(Object sender, EventArgs args)
		{
			okw = new ObrotyKontaWorker();
			ObrotyKontaWorker.Params p = (ObrotyKontaWorker.Params)DataContext1.Get(typeof(ObrotyKontaWorker.Params));
			OkresObrachunkowy o = (OkresObrachunkowy)DataContext1.Get(typeof(OkresObrachunkowy));
			Soneta.Core.OddzialParamsBase oddzialParams = (Soneta.Core.OddzialParamsBase)DataContext1.Get(typeof(Soneta.Core.OddzialParamsBase));
			Konta.Params p1 = (Konta.Params)DataContext1.Get(typeof(Konta.Params));
			okw.Param = p;

			ReportHeader1.Title =  string.Format(ReportHeader1.Title,
			   o, p.Okres,
			   p1.Typ, p1.Systematyka, p.Bufor ? "Tak" : "Nie", p.DekretyZamkniecia ? "Tak" : "Nie", CalcOpisNiezerowe(p1) ,
			   p1.Filtr, p1.OdKonta, p1.DoKonta, p1.NarastajacoZBO ? "Tak" : "Nie", p1.TypObrotow);
			
			if (oddzialParams.OddzialowoscEnabled)
				ReportHeader1.Title += string.Format("| Oddział: {0}", oddzialParams.Oddział);

			Row[] rows = (Row[])DataContext1.Get(typeof(Row[]));
			if (rows != null)
				foreach (Row row in rows)
					konta.Add(row, row);
		}



		private string CalcOpisNiezerowe(Konta.Params p1)
		{
			var items = new List<String>();

			if(p1.Niezerowe)
				items.Add("Niezerowe obroty");
			if(p1.NiezeroweSalda)
				items.Add("Niezerowe salda");
			if(p1.NiezeroweSaldaBO)
				items.Add("Niezerowe salda BO");

			if (items.Count == 0)
				return string.Empty;
			if (items.Count == 1)
				return "|" + items[0] + ": Tak";

			return "|" + string.Join(p1.NiezeroweCond == Konta.Params.NiezeroweWarunek.CondAnd ? " i ": " lub ", items);
		}


		private Params p;
		[Context]
		public Params P { set { p = value; } }


		public class Params : ContextBase
		{
			private Boolean wyrozniajSyntetyki;

			public Params(Context ctx) :
				base(ctx)
			{ wyrozniajSyntetyki = false; }


			[Caption("Wyróżniaj syntetyki")]
			public Boolean WyrozniajSyntetyki
			{
				get { return wyrozniajSyntetyki; }
				set { wyrozniajSyntetyki = value; }
			}
		}
		
	</script>
</head>
<body>
	<form id="ZestawienieObrotówISald" method="post" onload="ZestawienieObrotówISald_OnLoad" runat="server">
	<ea:DataContext ID="DataContext1" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business" Landscape="True" />
	<cc1:ReportHeader ID="ReportHeader1" Title="Zestawienie obrotów i sald | Okres obrachunkowy: {0}, Za okres: {1} | Typ kont: {2}, Systematyka: {3} | Uwzględniać bufor: {4} | Uwzględniać dekrety zamknięcia: {5}{6}| Filtr: {7} | Od konta: {8} | Do konta: {9} | Narastająco z BO : {10}, Typ obrotów: {11}" runat="server" />

	<ea:Grid ID="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Ksiega.KontoBase, Soneta.Ksiega, Version=1.0.1117.20240, Culture=neutral, PublicKeyToken=null" RowsInRow="1" ShowPrevAgrSum="InFooter" ShowAgrSum="True" ShowPageSum="True">
		<Columns>
			<ea:GridColumn runat="server" Width="15" ID="colSymbol" />
			<ea:GridColumn runat="server" Width="30" Total="Info" ID="colNazwa" />
			<ea:GridColumn runat="server" Align="Right" Total="Sum" Caption="Saldo BO Wn" Format="{0:n}" ID="colBOWn" />
			<ea:GridColumn runat="server" Align="Right" Total="Sum" Caption="Saldo BO Ma" Format="{0:n}" ID="colBOMa" />
			<ea:GridColumn runat="server" Align="Right" Visible="false" Total="Sum" Caption="PerSaldo BO" Format="{0:n}" ID="colSaldoBO" />
			<ea:GridColumn runat="server" Align="Right" Total="Sum" Caption="Obroty Wn" Format="{0:n}" ID="colObrotyWn" />
			<ea:GridColumn runat="server" Align="Right" Total="Sum" Caption="Obroty Ma" Format="{0:n}" ID="colObrotyMa" />
			<ea:GridColumn runat="server" Align="Right" Total="Sum" Caption="Obroty N Wn" Format="{0:n}" ID="colObrotyNWn" />
			<ea:GridColumn runat="server" Align="Right" Total="Sum" Caption="Obroty N Ma" Format="{0:n}" ID="colObrotyNMa" />
			<ea:GridColumn runat="server" Align="Right" Total="Sum" Caption="Saldo Wn" Format="{0:n}" ID="colSaldoWn" />
			<ea:GridColumn runat="server" Align="Right" Total="Sum" Caption="Saldo Ma" Format="{0:n}" ID="colSaldoMa" />
			<ea:GridColumn runat="server" Align="Right" Total="Sum" Caption="PerSaldo" Format="{0:n}" ID="colPerSaldo" />
		</Columns>
	</ea:Grid>

	<cc1:ReportFooter ID="ReportFooter1" runat="server">
		<Subtitles>
			<cc1:FooterSubtitle runat="server" SubtitleType="OperatorCzas" />
		</Subtitles>
	</cc1:ReportFooter>
	</form>
</body>
</html>

